package s6.springboot.tp.tp1.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import s6.springboot.tp.tp1.model.ItemCategory;
import s6.springboot.tp.tp1.repository.ItemCategoryRepository;

import java.util.List;

@Service
public class ItemCategoryService {
    private ItemCategoryRepository itemCategoryRepository;

    @Autowired
    public ItemCategoryService(ItemCategoryRepository itemCategoryRepository) {
        this.itemCategoryRepository = itemCategoryRepository;
    }

    public List<ItemCategory> getAllCategories() {
        System.out.println("Getting all categories");
        List<ItemCategory> list = itemCategoryRepository.findAll();
        return list;
    }

    public ItemCategory getCategoryByName(String categorie) {
        ItemCategory cat = itemCategoryRepository.findItemCategoryByName(categorie);
        return cat;
    }

    public ItemCategory createCategory(String name) {
        ItemCategory cat = new ItemCategory(name);
        itemCategoryRepository.save(cat);
        return cat;
    }



}
