package s6.springboot.tp.tp1.control;


import org.springframework.web.bind.annotation.*;
import s6.springboot.tp.tp1.model.ItemCategory;
import s6.springboot.tp.tp1.service.ItemCategoryService;


import java.util.List;

@RestController
public class ItemCategoryController {

    private final ItemCategoryService itemCategoryService;

    ItemCategoryController(ItemCategoryService itemCategoryService) {
        this.itemCategoryService = itemCategoryService;
    }

    @GetMapping("/rpg/categories")
    public List<ItemCategory> getAllCategories() {
        List<ItemCategory> list = itemCategoryService.getAllCategories();
       return list;
    }

    @PostMapping("/rpg/categories/{name}")
    public ItemCategory createCategory(@PathVariable String name) {
        System.out.println("create a new category "+name);
        return itemCategoryService.createCategory(name);
    }
}
