package s6.springboot.tp.tp1.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import s6.springboot.tp.tp1.model.ItemCategory;
import s6.springboot.tp.tp1.model.RpgItem;
import s6.springboot.tp.tp1.repository.RpgItemRepository;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class RpgItemService {
    private RpgItemRepository rpgItemRepository;
    private ItemCategoryService itemCategoryService;

    @Autowired
    public RpgItemService(RpgItemRepository rpgItemRepository, ItemCategoryService itemCategoryService) {
        this.rpgItemRepository = rpgItemRepository;
        this.itemCategoryService = itemCategoryService;
    }

    public Optional<RpgItem> getIdemById(Long id) {
        return rpgItemRepository.findById(id);
    }
    public List<RpgItem> getAllItems() {
        System.out.println("Getting all items");
        List<RpgItem> list = rpgItemRepository.findAll();
        return list;
    }

    public List<RpgItem> getItemsByCategory(String category) {
        System.out.println("Getting items by category "+category);
        ItemCategory cat = itemCategoryService.getCategoryByName(category);
        if (cat == null) return new ArrayList<RpgItem>();

        List<RpgItem> list = rpgItemRepository.findAllByIdCategory(cat.getId());
        return list;
    }

    public List<RpgItem> getItemsByCategoryUnderPrice(String category, double price) {
        System.out.println("Getting items by category "+category+ " with cost under "+price);
        ItemCategory cat = itemCategoryService.getCategoryByName(category);
        if (cat == null) return new ArrayList<RpgItem>();

        List<RpgItem> list = rpgItemRepository.findAllByIdCategoryAndPriceLessThan(cat.getId(), price);
        return list;
    }

    public List<RpgItem>getItemsNameContaining(List<String> patterns) {
        List<RpgItem> list = new ArrayList<>();
        for(String p : patterns) {
            list.addAll(rpgItemRepository.findAllByNameContaining(p));
        }
        return list;
    }

    public List<RpgItem> getItemsNoEffect() {
        List<RpgItem> list = rpgItemRepository.findAllByEffectEquals("");
        return list;
    }

    public RpgItem createItem(String name, Long idCategory, Double price, String effect) {
        RpgItem item = new RpgItem(name, idCategory, price, effect);
        rpgItemRepository.save(item);
        System.out.println("new item: "+item);
        return item;
    }

    public RpgItem updateItem(Long id, String name, Long idCategory, Double price, String effect) {
        Optional<RpgItem> item = rpgItemRepository.findById(id);
        if (item.isPresent()) {
            RpgItem it = item.get();
            if (name != null) it.setName(name);
            if (idCategory != null) it.setIdCategory(idCategory);
            if (price != null) it.setPrice(price);
            if (effect != null) it.setEffect(effect);
            rpgItemRepository.save(it);
            return it;
        }
        return new RpgItem();
    }

}
