package s6.springboot.tp.tp1.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import s6.springboot.tp.tp1.model.RpgItem;

import java.util.List;

public interface RpgItemRepository extends JpaRepository<RpgItem, Long> {

    List<RpgItem> findAllByIdCategory(Long idCategory);
    List<RpgItem> findAllByIdCategoryAndPriceLessThan(Long idCategory, double price);
    List<RpgItem> findAllByNameContaining(String pattern);
    List<RpgItem> findAllByEffectEquals(String effect); // can be used to search for empty string
}
