package s6.springboot.tp.tp1.control;


import org.springframework.web.bind.annotation.*;
import s6.springboot.tp.tp1.model.RpgItem;
import s6.springboot.tp.tp1.model.RpgItemDTO;
import s6.springboot.tp.tp1.service.RpgItemService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

@RestController
public class RpgItemController {

    private final RpgItemService rpgItemService;

    RpgItemController(RpgItemService rpgItemService) {
        this.rpgItemService = rpgItemService;
    }

    @GetMapping("/rpg/items")
    public List<RpgItem> getAllItems(@RequestParam(required = false) String patterns) {
        List<RpgItem> list = new ArrayList<>();
        if (patterns == null) {
            System.out.println("Getting all items");
            list = rpgItemService.getAllItems();
        }
        else {
            System.out.println("Getting items with name containing "+patterns);
            List<String> parts = Arrays.asList(patterns.split(","));
            list = rpgItemService.getItemsNameContaining(parts);
        }
       return list;
    }

    @GetMapping("/rpg/items/{category}")
    public List<RpgItem> getItemsByCategory(@PathVariable String category, @RequestParam(required = false) Double maxprice) {
        List<RpgItem> list = new ArrayList<>();
        if (maxprice == null) {
            System.out.println("Getting items of category " + category);
            list = rpgItemService.getItemsByCategory(category);
        }
        else {
            System.out.println("Getting items of category " + category+ " with cost lower than "+maxprice);
            list = rpgItemService.getItemsByCategoryUnderPrice(category, maxprice);
        }
        return list;
    }

    @GetMapping("/rpg/items/noeffect")
    public List<RpgItem> getItemsWithNoEffect() {
        System.out.println("Getting items with no effect");
        List<RpgItem> list = rpgItemService.getItemsNoEffect();
        return list;
    }

    @PostMapping("/rpg/items")
    public RpgItem createItem(@RequestBody RpgItemDTO item) {
        System.out.println("Create an item from DTO "+item);
        // check if effect is provided.
        String effect = item.getEffect();
        if (effect == null) effect = "";
        return rpgItemService.createItem(item.getName(), item.getIdCategory(), item.getPrice(), effect);
    }

    @PutMapping("/rpg/items/{id}")
    public RpgItem updateItem(@PathVariable Long id, @RequestBody RpgItemDTO item) {
        System.out.println("update item id = "+id+ " from DTO "+item);

        return rpgItemService.updateItem(id, item.getName(), item.getIdCategory(), item.getPrice(), item.getEffect());
    }
}
