package com.td4.example.demo1.service;

import com.td4.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td4.example.demo1.model.*;
import com.td4.example.demo1.model.DTO.OrganizationDTO;
import com.td4.example.demo1.repository.OrganizationsRepository;
import com.td4.example.demo1.repository.TeamsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class OrganizationsService {
    private OrganizationsRepository organizationsRepository;
    private TeamsRepository teamsRepository;

    @Autowired
    public OrganizationsService(OrganizationsRepository organizationsRepository, TeamsRepository teamsRepository) {
        this.organizationsRepository = organizationsRepository;
        this.teamsRepository = teamsRepository;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Organization> findAllOrganizations() {
        return organizationsRepository.findAll();
    }

    public Organization findOrganizationById(String id) throws ResourceNotFoundException {
        System.out.println("Getting organization by id: " + id);
        Optional<Organization> org = organizationsRepository.findById(id);
        if (org.isEmpty()) throw new ResourceNotFoundException("searching for organization with id = "+id);
        return org.get();
    }
}
