package com.td4.example.demo1.model;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.DocumentReference;

import java.util.List;

@Document("teams")
public class Team {

    @Id
    private String id;

    private String name;

    // do not get members until it is needed (i.e. access to one or more members)
    @DocumentReference(lazy = true)
    private List<Hero> members;

    public Team(String id, String name, List<Hero> members) {
        this.id = id;
        this.name = name;
        this.members = members;
    }

    public Team(String name, List<Hero> members) {
        this.name = name;
        this.members = members;
    }

    public Team(String id) {
        this.id = id;
    }

    public Team() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Hero> getMembers() {
        return members;
    }

    public void setMembers(List<Hero> members) {
        this.members = members;
    }


    @Override
    public String toString() {
        return "Team{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", heroes=" + members +
                '}';
    }
}
