package com.td4.example.demo1.model;

import com.td4.example.demo1.model.DTO.PowerDTO;

public class Power {

    /* NB on whether Power contains an id or not:
       Power is embedded within a Hero. From mongo point of view, it is a JSON
       object within the array powers of a Hero document. Thus, it is a subdocument
       and under certain conditions, it may have its own id, even if it is not
       mandatory since it is not stored in a separate collection.

       For example, having an id in subdocument occurs when creating schema with mongoose :
       If a schema uses another schema as a field type, then, by default, mongoose will
       create an _id for subdocuments.

       If the spring API must use the same mongo DB, created via mongoose, then it muse also
       uses subdocuments with their owns ids. In such a case, it is sufficient to declare
       an attribute String id (and NOT _id). Spring will (de)serialize it to/from _id in the json.
     */

    // uncomment next attribute if there is effectively an id in a power subdocument for heroes
    //private String id;
    private String name;
    private int type;
    private int level;

    // uncomment next constructor if there is effectively an id in a power subdocument for heroes
    /*
    public Power(String id, String name, int type, int level) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.level = level;
    }
     */

    public Power(String name, int type, int level) {
        this.name = name;
        this.type = type;
        this.level = level;
    }

    public Power() {
    }

    public Power(PowerDTO power) {
        // uncomment next line if there is effectively an id in a power subdocument for heroes
        //this.id = power.getId();
        this.name = power.getName();
        this.type = power.getType();
        this.level = power.getLevel();
    }

    // uncomment two nxt methods if there is effectively an id in a power subdocument for heroes
    /*
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

     */

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String toString() {
        return "Power{" +
    //          "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", type=" + type +
                ", level=" + level +
                '}';
    }
}
