package com.td4.example.demo1.model.DTO;

import com.td4.example.demo1.model.Hero;
import com.td4.example.demo1.model.Team;

import java.util.ArrayList;
import java.util.List;

public class TeamDTO {

    private String id;
    private String name;
    private List<HeroDTO> members;

    public TeamDTO(String id, String name, List<HeroDTO> members) {
        this.id = id;
        this.name = name;
        this.members = members;
    }

    public TeamDTO(String id) {
        this(id, null, null);
    }

    public TeamDTO(String name, List<HeroDTO> members) {
        this(null, name, members);
    }

    public TeamDTO() {
    }

    public TeamDTO(Team team) {
        this.id = team.getId();
        this.name = team.getName();
        List<Hero> heroes = team.getMembers();
        this.members = new ArrayList<>();
        for (Hero hero : heroes) {
            this.members.add(new HeroDTO(hero));
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<HeroDTO> getMembers() {
        return members;
    }

    public void setMembers(List<HeroDTO> members) {
        this.members = members;
    }

    @Override
    public String toString() {
        return "Team{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", members=" + members +
                '}';
    }
}
