package com.td4.example.demo1.model.DTO;

import com.td4.example.demo1.model.Hero;
import com.td4.example.demo1.model.Power;

import java.util.ArrayList;
import java.util.List;

/*
This class is used to represent a Hero object received from a client of this
application. Instances of this class are automatically build by spring when a controller
as a HeroDTO parameter annotated with @RequestBody ( see createHero(), updateHero() )
 */
public class HeroDTO {

    /*
    In order to be able to receive updated info about a hero, but without
    all fields provided, it is useful to declare all attributes as object.
    Indeed, when receiving a JSON with missing fields, spring will deserialize
    it in a HeroDTO instance setting null to attributes that correspond to a missing field.
     */
    private String id;
    private String publicName;
    private String realName;
    private List<PowerDTO> powers;


    public HeroDTO(String id, String publicName, String realName, List<PowerDTO> powers) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.powers = powers;
    }

    public HeroDTO() {
        this(null,null,null,null);
    }

    public HeroDTO(String publicName, String realName, List<PowerDTO> powers) {
        this(null, publicName, realName, powers);
    }

    public HeroDTO(Hero hero) {
        this.id = hero.getId();
        this.publicName = hero.getPublicName();
        this.realName = hero.getRealName();
        this.powers = new ArrayList<>();
        List<Power> powers = hero.getPowers();
        for(Power power : powers) {
            this.powers.add(new PowerDTO(power));
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public List<PowerDTO> getPowers() {
        return powers;
    }

    public void setPowers(List<PowerDTO> powers) {
        this.powers = powers;
    }

    @Override
    public String toString() {
        return "HeroDTO{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", powers=" + powers +
                '}';
    }
}
