package com.td4.example.demo1.control.filters;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.td4.example.demo1.model.DTO.TeamDTO;

import java.io.IOException;
import java.util.List;

public class CustomTeamDTOListSerializer extends StdSerializer<List<TeamDTO>> {

    private static final long serialVersionUID = 1L;

    public CustomTeamDTOListSerializer() {
        this(null);
    }
    public CustomTeamDTOListSerializer(Class<List<TeamDTO>> t) {
        super(t);
    }
    @Override
    public void serialize(List<TeamDTO> list, JsonGenerator generator, SerializerProvider arg2) throws IOException {
        // check if the list contains only ids
        boolean justId = true;
        for(TeamDTO team : list) {
            if ((team.getMembers() != null) || (team.getName() != null)) {
                justId = false;
                break;
            }
        }
        if (justId) {
            generator.writeStartArray();
            for (TeamDTO team : list) {
                generator.writeString(team.getId());
            }
            generator.writeEndArray();
        }
        else {
            generator.writeObject(list);
        }
    }
}

