package com.td4.example.demo1.control;

import com.td4.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td4.example.demo1.model.Hero;
import com.td4.example.demo1.model.DTO.HeroDTO;
import com.td4.example.demo1.model.Power;
import com.td4.example.demo1.model.DTO.PowerDTO;
import com.td4.example.demo1.service.HeroesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;

    @Autowired
    HeroesController(HeroesService heroesService) {
        this.heroesService = heroesService;
    }

    // get all heroes
    @GetMapping("/heroes")
    public List<HeroDTO> getAllHeroes() {
        List<Hero> heroes = heroesService.findAllHeroes();
        List<HeroDTO> heroesDTO = new ArrayList<>();
        for(Hero hero : heroes) {
            heroesDTO.add(new HeroDTO(hero));
        }
        return heroesDTO;
    }

    // create a hero
    @PostMapping("/heroes")
    public HeroDTO createHero(@RequestBody HeroDTO hero)  {
        List<Power> powers = new ArrayList<>();
        for(PowerDTO power : hero.getPowers()) {
            powers.add(new Power(power));
        }
        Hero newHero = heroesService.createHero( hero.getPublicName(), hero.getRealName(), powers);
        return new HeroDTO(newHero);
    }

    // get hero by id
    @GetMapping("/heroes/{id}")
    public HeroDTO getHeroById(@PathVariable String id) throws ResourceNotFoundException {
        Hero hero = heroesService.findHeroById(id);
        return new HeroDTO(hero);
    }

    // delete hero by id
    @DeleteMapping("/heroes/{id}")
    public void deleteHeroById(@PathVariable String id) throws ResourceNotFoundException {
        heroesService.deleteHero(id);
    }

    @GetMapping("/heroes/getbypublicname/{name}")
    public HeroDTO getHeroByPublicName(@PathVariable String name) throws ResourceNotFoundException {
        Hero hero = heroesService.findHeroByPublicName(name);
        return new HeroDTO(hero);
    }

    @GetMapping("/heroes/getbypublicnamelike/{pattern}")
    public Page<Hero> getHeroByPublicName(@PathVariable String pattern, Pageable pageable) throws ResourceNotFoundException {
        Page<Hero> pages = heroesService.findHeroesByPublicNameLike(pattern, pageable);
        return pages;
    }

    @GetMapping("/heroes/getbypower")
    public List<HeroDTO> getHeroesByPower(@RequestParam String power, @RequestParam(required = false) Boolean pattern) {

        if (pattern == null) pattern = false;
        List<Hero> heroes = heroesService.findAllByPower(power,pattern);
        List<HeroDTO> heroesDTO = new ArrayList<>();
        for(Hero hero : heroes) {
            heroesDTO.add(new HeroDTO(hero));
        }
        return heroesDTO;
    }
}
