package com.td4.example.demo1;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.td4.example.demo1.model.Hero;
import com.td4.example.demo1.model.Organization;
import com.td4.example.demo1.model.Team;
import com.td4.example.demo1.repository.HeroesRepository;
import com.td4.example.demo1.repository.OrganizationsRepository;
import com.td4.example.demo1.repository.TeamsRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;


@Component
public class MyRunner implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(MyRunner.class);

    private final HeroesRepository heroesRepository;
    private final TeamsRepository teamsRepository;
    private final OrganizationsRepository organizationsRepository;

    @Autowired
    public MyRunner(HeroesRepository heroesRepository, TeamsRepository teamsRepository,OrganizationsRepository organizationsRepository) {
        this.heroesRepository = heroesRepository;
        this.teamsRepository = teamsRepository;
        this.organizationsRepository = organizationsRepository;
    }

    @Override
    @Transactional
    public void run(String... args) throws Exception {
        ObjectMapper mapper = new ObjectMapper();

        logger.info("initializing heroes");
        TypeReference<List<Hero>> heroesReference = new TypeReference<>(){};
        InputStream inputStream = TypeReference.class.getResourceAsStream("/heroes.json");
        List<Hero> heroes = null;
        try {
            heroes = mapper.readValue(inputStream,heroesReference);
        } catch (IOException e){
            System.out.println("Unable to read hero: " + e.getMessage());
        }
        for(Hero hero : heroes) {
            System.out.println(hero);
            // uncomment next line to save in mongodb
            heroesRepository.save(hero);
        }

        logger.info("initializing teams");
        TypeReference<List<Team>> teamsReference = new TypeReference<>(){};
        inputStream = TypeReference.class.getResourceAsStream("/teams.json");
        List<Team> teams = null;
        try {
            teams = mapper.readValue(inputStream,teamsReference);
        } catch (IOException e){
            System.out.println("Unable to read team: " + e.getMessage());
        }
        for(Team team : teams) {
            System.out.println(team);
            // uncomment next line to save in mongodb
            teamsRepository.save(team);
        }
        
        logger.info("initializing organizations");
        TypeReference<List<Organization>> organizationsReference = new TypeReference<>(){};
        inputStream = TypeReference.class.getResourceAsStream("/organizations.json");
        List<Organization> organizations = null;
        try {
            organizations = mapper.readValue(inputStream,organizationsReference);
        } catch (IOException e){
            System.out.println("Unable to read team: " + e.getMessage());
        }
        for(Organization organization : organizations) {
            System.out.println(organization);
            // uncomment next line to save in mongodb
            organizationsRepository.save(organization);
        }
    }
}
