package com.td4.example.demo1.service;

import com.td4.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td4.example.demo1.model.Team;
import com.td4.example.demo1.model.DTO.TeamDTO;
import com.td4.example.demo1.repository.TeamsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class TeamsService {
    private TeamsRepository teamsRepository;

    @Autowired
    public TeamsService(TeamsRepository teamsRepository) {
        this.teamsRepository = teamsRepository;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Team> findAllTeams() {
        return teamsRepository.findAll();
    }

    public Team findTeamById(String id) throws ResourceNotFoundException {
        System.out.println("Getting team by id: " + id);
        Optional<Team> team = teamsRepository.findById(id);
        if (team.isEmpty()) throw new ResourceNotFoundException("searching for team with id = "+id);
        return team.get();
    }
}
