package com.td4.example.demo1.repository;

import com.td4.example.demo1.model.Hero;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;

import java.util.List;
import java.util.Optional;

public interface HeroesRepository extends MongoRepository<Hero, String> {

    Optional<Hero> findByPublicName(String publicName);

    @Query(value="{publicName: {$regex: '?0'}}")
    Page<Hero> findAllByPublicNameLike(String pattern, Pageable pageable);

    @Query(value="{powers:{$elemMatch: { name:'?0'}}}")
    List<Hero> findAllByPower(String power);
    @Query(value="{powers: {$elemMatch: { name: {$regex: '?0'}}}}")
    List<Hero> findAllByPowerContaining(String pattern);
}
