package com.td4.example.demo1.model;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.DocumentReference;

import java.util.List;

@Document("organizations")
public class Organization {

    @Id
    private String id;

    private String name;
    private String secret;

    /* NB on not using @DocumentReference + List<Team>
       The simplest way to avoid that mongo orm fetches every team for an organization
       is to get only the id of the teams, as String.
       That way, the JSON object representing an organization will not contain a json object
       taht represents every team within, but only an array with their id. Thus, further requests
       are needed to get the teams by id if needed (see OrganizationController.getFullOrganizationById() )
     */
    private List<String> teams;

    public Organization(String id, String name, String secret, List<String> teams) {
        this.id = id;
        this.name = name;
        this.secret = secret;
        this.teams = teams;
    }

    public Organization(String name, String secret, List<String> teams) {
        this.name = name;
        this.secret = secret;
        this.teams = teams;
    }

    public Organization() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public List<String> getTeams() {
        return teams;
    }

    public void setTeams(List<String> teams) {
        this.teams = teams;
    }

    @Override
    public String toString() {
        return "Organization{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", secretPass='" + secret + '\'' +
                ", teams=" + teams +
                '}';
    }
}
