package com.td4.example.demo1.model;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;


@Document("heroes")
public class Hero {

    @Id
    private String id;

    private String publicName;
    // BdD name will be by default real_name
    private String realName;
    private List<Power> powers;

    public Hero() {}

    // IMPORTANT ! must define constructor with only id as parameter
    // in case of a team read from a json with only a ref to a heroes document in members field.
    public Hero(String id) {
        this.id = id;
    }

    public Hero(String id, String publicName, String realName, List<Power> powers) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.powers = powers;
    }

    public Hero(String publicName, String realName, List<Power> powers) {
        this.publicName = publicName;
        this.realName = realName;
        this.powers = powers;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public List<Power> getPowers() {
        return powers;
    }

    public void setPowers(List<Power> powers) {
        this.powers = powers;
    }

    @Override
    public String toString() {
        return "Hero{" +
                "id='" + id + '\'' +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", powers=" + powers +
                '}';
    }
}
