package com.td4.example.demo1.model.DTO;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.td4.example.demo1.control.filters.CustomTeamDTOListSerializer;
import com.td4.example.demo1.model.Organization;
import com.td4.example.demo1.model.Team;

import java.util.ArrayList;
import java.util.List;

public class OrganizationDTO {

    private String id;
    private String name;
    private String secret;
    // use a special serializer to get different result if teams contains full info or not.
    @JsonSerialize(using = CustomTeamDTOListSerializer.class)
    private List<TeamDTO> teams;

    // constructor used when only team ids have been fetched
    public OrganizationDTO(Organization organization) {
        this.id = organization.getId();
        this.name = organization.getName();
        this.secret = organization.getSecret();
        List<String> teams = organization.getTeams();
        this.teams = new ArrayList<>();
        for(String teamId : teams) {
            // use the Team constructor that only initializes the id
            this.teams.add(new TeamDTO(teamId));
        }
    }

    // constructor used when full team infos have been fetched
    public OrganizationDTO(Organization organization, List<Team> teams) {
        this.id = organization.getId();
        this.name = organization.getName();
        this.secret = organization.getSecret();
        this.teams = new ArrayList<>();
        for(Team team : teams) {
            // use the Team constructor that initializes the full TeamDTO from a Team
            this.teams.add(new TeamDTO(team));
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecret() {
        return secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public List<TeamDTO> getTeams() {
        return teams;
    }

    public void setTeams(List<TeamDTO> teams) {
        this.teams = teams;
    }
}
