package com.td4.example.demo1.model.DTO;

/*
   This class is used to represent an error answer message to an http request.
   When return by a controller, or an advice controller, it is automatically
   serialized by spring into an equivalent JSON object, that is received by the asking client.
 */
public class ErrorDTO {

    private Integer errorNumber;
    private String context;
    private String message;

    public ErrorDTO(Integer number, String context, String message) {
        this.errorNumber = number;
        this.context = context;
        this.message = message;
    }

    public ErrorDTO(Integer number, String message) {
        this(number, "", message);
    }

    public Integer getErrorNumber() {
        return errorNumber;
    }

    public void setErrorNumber(Integer errorNumber) {
        this.errorNumber = errorNumber;
    }

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "ErrorDTO{" +
                "errorNumber=" + errorNumber +
                ", context='" + context + '\'' +
                ", message='" + message + '\'' +
                '}';
    }
}
