package com.td4.example.demo1.control;

import com.td4.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td4.example.demo1.model.DTO.TeamDTO;
import com.td4.example.demo1.model.Team;
import com.td4.example.demo1.service.TeamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
public class TeamsController {

    private final TeamsService teamsService;

    @Autowired
    TeamsController(TeamsService teamsService) {
        this.teamsService = teamsService;
    }

    // get all teames
    @GetMapping("/teams")
    public List<TeamDTO> getAllTeames() {
        List<Team> teams = teamsService.findAllTeams();
        List<TeamDTO> teamsDTO = new ArrayList<>();
        for(Team team : teams) {
            teamsDTO.add(new TeamDTO(team));
        }
        return teamsDTO;
    }

    // get team by id
    @GetMapping("/teams/{id}")
    public TeamDTO getTeamById(@PathVariable String id) throws ResourceNotFoundException {
        Team team = teamsService.findTeamById(id);
        return new TeamDTO(team);
    }
}
