package com.td4.example.demo1.control;

import com.td4.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td4.example.demo1.model.DTO.OrganizationDTO;
import com.td4.example.demo1.model.Organization;
import com.td4.example.demo1.model.Team;
import com.td4.example.demo1.service.OrganizationsService;
import com.td4.example.demo1.service.TeamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@RestController
public class OrganizationsController {

    private final OrganizationsService organizationsService;
    private final TeamsService teamsService;

    @Autowired
    OrganizationsController(OrganizationsService organizationsService, TeamsService teamsService) {
        this.organizationsService = organizationsService;
        this.teamsService = teamsService;
    }

    // get all organizations
    @GetMapping("/organizations")
    public List<OrganizationDTO> getAllOrganizationes() {
        List<Organization> organizations =  organizationsService.findAllOrganizations();
        List<OrganizationDTO> organizationDTO = new ArrayList<>();
        for(Organization organization : organizations) {
            organizationDTO.add(new OrganizationDTO(organization));
        }
        return organizationDTO;
    }

    // get organization by id, with only teams id
    @GetMapping("/organizations/{id}")
    public OrganizationDTO getOrganizationById(@PathVariable String id) throws ResourceNotFoundException {
        Organization organization = organizationsService.findOrganizationById(id);
        return new OrganizationDTO(organization);
    }

    // get organization by id, with teams fulfilled
    @GetMapping("/organizations/{id}/full")
    public OrganizationDTO getFullOrganizationById(@PathVariable String id) throws ResourceNotFoundException {

        Organization organization = organizationsService.findOrganizationById(id);
        List<Team> teams = new ArrayList<>();
        for(String teamId : organization.getTeams()) {
            teams.add(teamsService.findTeamById(teamId));
        }
        return new OrganizationDTO(organization, teams);
    }
}
