package com.td3.example.demoAll.service;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.control.exceptions.ResourceNotDeletedException;
import com.td3.example.demoAll.control.exceptions.ResourceNotFoundException;
import com.td3.example.demoAll.model.*;
import com.td3.example.demoAll.repository.TeamsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class TeamsService {
    private TeamsRepository teamsRepository;
    private HeroesService heroesService;

    @Autowired
    public TeamsService(TeamsRepository teamsRepository, HeroesService heroesService) {
        this.teamsRepository = teamsRepository;
        this.heroesService = heroesService;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Team> findAll() {
        return teamsRepository.findAll();
    }

    public Team findTeamById(Long id) throws ResourceException {
        Optional<Team> teamOpt = teamsRepository.findById(id);
        if (teamOpt.isEmpty()) throw new ResourceNotFoundException("searching for team with id = "+id);
        return teamOpt.get();
    }

    /* *********************************************
       services to update data
    *********************************************** */
    public void addHeroToTeam(Long teamId, Long heroId) throws  ResourceException {
        Team team = findTeamById(teamId);
        Hero hero = heroesService.findHeroById(heroId);
        team.getHeroes().add(hero);
        teamsRepository.save(team);
    }

    /* *********************************************
       services to delete data
    *********************************************** */
    public void removeHeroFromTeam(Long teamId, Long heroId) throws  ResourceException {
        Team team = findTeamById(teamId);
        Hero hero = heroesService.findHeroById(heroId);
        if (team.getHeroes().remove(hero)) {
            teamsRepository.save(team);
        }
    }

    public void removeHeroFromAllTeams(Long heroId) throws  ResourceException {
        Hero hero = heroesService.findHeroById(heroId);
        List<Team> list = teamsRepository.findAllByHeroesId(heroId);
        for(Team team : list) {
            if (team.getHeroes().remove(hero)) {
                teamsRepository.save(team);
            }
        }
    }

    public void deleteTeam(Long id) throws ResourceException {
        Optional<Team> teamOpt = teamsRepository.findById(id);
        if (teamOpt.isEmpty()) throw new ResourceNotFoundException("deleting team with id = "+id);
        try {
            teamsRepository.deleteById(id);
        }
        catch(Exception e) {
            throw new ResourceNotDeletedException("relationship with another table prevents from deleting team with id = "+id);
        }
    }
}
