package com.td3.example.demoAll.service;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.model.Hero;
import com.td3.example.demoAll.model.HeroPowerLevel;
import com.td3.example.demoAll.model.Power;
import com.td3.example.demoAll.repository.HeroPowerLevelsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class HeroPowerLevelsService {
    private HeroPowerLevelsRepository heroPowerLevelsRepository;
    private HeroesService heroesService; // user to get heroes
    private PowersService powersService;

    @Autowired
    public HeroPowerLevelsService(HeroPowerLevelsRepository heroPowerLevelsRepository, HeroesService heroesService, PowersService powersService) {
        this.heroPowerLevelsRepository = heroPowerLevelsRepository;
        this.heroesService = heroesService;
        this.powersService = powersService;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<HeroPowerLevel> findHeroPowers(Long heroId) {
        System.out.println("Getting powers of hero: " + heroId);
        List<HeroPowerLevel> list = heroPowerLevelsRepository.findAllByHeroId(heroId);
        return list;
    }

    /* *********************************************
       services to update data
    *********************************************** */
    public List<HeroPowerLevel> addPowerToHero(Long heroId, Long powerId, Integer level) throws ResourceException {
        Hero hero = heroesService.findHeroById(heroId);
        if (hero != null) System.out.println(hero.getPublicName()+" "+hero);
        Power power = powersService.findPowerById(powerId);
        if (power != null) System.out.println(power);
        int l = 0;
        if ((level != null) || (level > 0)) l = level;
        HeroPowerLevel heroPowerLevel = new HeroPowerLevel(hero, power, l);
        heroPowerLevelsRepository.save(heroPowerLevel);
        List<HeroPowerLevel> list = findHeroPowers(heroId);
        return list;
    }
}
