package com.td3.example.demoAll.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import jakarta.persistence.*;

import java.util.List;

@Entity
@Table(name="teams")
public class Team {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    // using @Column just to illustrate its possible uses.
    @Column(name="name", nullable = false, unique = true, length = 50)
    private String name;

    /* Set a many-to-many unidirectional relationship between Team and Hero, i.e.
       a team may include several herores, and a hero can be member of several teams.
       It implies to create a new table with two foreign keys corresponding to primary keys of
       teams and heroes tables.

       Note that the unidrectional way just serves as an example and may not really helping. Indeed,
       it would be interesting to directly get for a given hero the teams he belongs to.
    */
    @ManyToMany
    @JoinTable(name = "teams_heroes",
            joinColumns = @JoinColumn(name = "team_id"),
            inverseJoinColumns = @JoinColumn(name = "hero_id"))
    private List<Hero> heroes;

    /* Set a many-to-many bidirectional relationship between organizations and teams.
     The "owner" side is declared in Organization. This, we must declare the "owned" side in this class, using @ManyToMany and mappedBy.
      mappedBy must refer to the attribute name used in Organization to store the teams, which is in the present case: teams.

      !!! WARNING !!! if cascade is used here, e.g. on remove, then deleting a team with also remove the associated organizations, which is NOT desirable.
    */
    @ManyToMany(mappedBy = "teams")
    private List<Organization> organizations ;

    public Team(Long id, String name, List<Hero> heroes, List<Organization> organizations) {
        this.id = id;
        this.name = name;
        this.heroes = heroes;
        this.organizations = organizations;
    }

    public Team(String name, List<Hero> heroes, List<Organization> organizations) {
        this.name = name;
        this.heroes = heroes;
        this.organizations = organizations;
    }

    public Team() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Hero> getHeroes() {
        return heroes;
    }

    public void setHeroes(List<Hero> heroes) {
        this.heroes = heroes;
    }

    public List<Organization> getOrganizations() {
        return organizations;
    }

    public void setOrganizations(List<Organization> organizations) {
        this.organizations = organizations;
    }

    @Override
    public String toString() {
        return "Team{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", heroes=" + heroes +
                ", organizations=" + organizations +
                '}';
    }
}
