package com.td3.example.demoAll.model;


import jakarta.persistence.*;

@Entity
@Table(name = "power_types")
public class PowerType {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    @Column(name="type", nullable = false, unique = true, length = 50)
    private String type;

    public PowerType(Long id, String type) {
        this.id = id;
        this.type = type;
    }

    public PowerType(String type) {
        this.type = type;
    }

    public PowerType() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "PowerType{" +
                "id=" + id +
                ", type='" + type + '\'' +
                '}';
    }
}
