package com.td3.example.demoAll.model.DTO;

import com.td3.example.demoAll.model.Hero;
import com.td3.example.demoAll.model.Organization;
import com.td3.example.demoAll.model.Team;

import java.util.ArrayList;
import java.util.List;

public class TeamDTO {

    private Long id;
    private String name;
    private List<Long> heroesId;
    private List<Long> organizationsId;

    public TeamDTO(Team team) {
        this.id = team.getId();
        this.name = team.getName();
        heroesId = new ArrayList<>();
        organizationsId = new ArrayList<>();
        for(Hero hero : team.getHeroes()) {
            heroesId.add(hero.getId());
        }
        for(Organization organization : team.getOrganizations()) {
            organizationsId.add(organization.getId());
        }
    }

    public TeamDTO(Long id, String name, List<Long> heroesId, List<Long> organizationsId) {
        this.id = id;
        this.name = name;
        this.heroesId = heroesId;
        this.organizationsId = organizationsId;
    }

    public TeamDTO(String name, List<Long> heroesId, List<Long> organizationsId) {
        this.name = name;
        this.heroesId = heroesId;
        this.organizationsId = organizationsId;
    }

    public TeamDTO() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Long> getHeroesId() {
        return heroesId;
    }

    public void setHeroesId(List<Long> heroesId) {
        this.heroesId = heroesId;
    }

    public List<Long> getOrganizationsId() {
        return organizationsId;
    }

    public void setOrganizationsId(List<Long> organizationsId) {
        this.organizationsId = organizationsId;
    }
}
