package com.td3.example.demoAll.model.DTO;

import com.td3.example.demoAll.model.Hero;
import com.td3.example.demoAll.model.Organization;
import com.td3.example.demoAll.model.Team;

import java.util.ArrayList;
import java.util.List;

public class OrganizationDTO {

    private Long id;
    private String name;
    private String secretPass;
    private List<Long> teamsId;

    public OrganizationDTO(Organization organization) {
        this.id = organization.getId();
        this.name = organization.getName();
        this.secretPass = organization.getSecretPass();
        teamsId = new ArrayList<>();
        for(Team team : organization.getTeams()) {
            teamsId.add(team.getId());
        }
    }

    public OrganizationDTO(Long id, String name, String secretPass, List<Long> teamsId) {
        this.id = id;
        this.name = name;
        this.secretPass = secretPass;
        this.teamsId = teamsId;
    }

    public OrganizationDTO(String name, String secretPass, List<Long> teamsId) {
        this.name = name;
        this.secretPass = secretPass;
        this.teamsId = teamsId;
    }

    public OrganizationDTO() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretPass() {
        return secretPass;
    }

    public void setSecretPass(String secretPass) {
        this.secretPass = secretPass;
    }

    public List<Long> getTeamsId() {
        return teamsId;
    }

    public void setTeamsId(List<Long> teamsId) {
        this.teamsId = teamsId;
    }
}
