package com.td3.example.demoAll.control;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.model.DTO.OrganizationDTO;
import com.td3.example.demoAll.model.Organization;
import com.td3.example.demoAll.service.OrganizationsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
public class OrganizationsController {

    private final OrganizationsService organizationsService;

    @Autowired
    OrganizationsController(OrganizationsService organizationsService) {
        this.organizationsService = organizationsService;
    }

    /* !!! WARNING !!!
        controller MUST NOT send back a Organization object, counting on the default serialization to
        create the JSON object for the answer's body. Indeed, due to bidirectional relationship with Team
        that are not annotated with @JsonManagedReference & @JsonBackReference, this would lead
        to an infinite recursion during serialisation.
        This is why each controller must send back OrganizationDTO objects, constructed from Organization objects.
     */
    // get all organizations
    @GetMapping("/organizations")
    public List<OrganizationDTO> getAllOrganization() {

        List<Organization> list = organizationsService.findAll();
        List<OrganizationDTO> listDTO = new ArrayList<>();
        for(Organization organization : list) {
            listDTO.add(new OrganizationDTO(organization));
        }
        return listDTO;
    }
    // get organisation by id
    @GetMapping("/organizations/{id}")
    public OrganizationDTO getOrganizationById(@PathVariable Long id) throws ResourceException {
        Organization organization = organizationsService.findOrganizationById(id);
        return new OrganizationDTO(organization);
    }

    // delete organisation by id
    @DeleteMapping("/organizations/{id}")
    public void deleteOrganization(@PathVariable  Long id) throws ResourceException {
        organizationsService.deleteOrganization(id);
    }

    @PostMapping("/organizations/{id}/addteam/{team}")
    public void addTeamToOrganization(@PathVariable Long id, @PathVariable Long team) throws ResourceException {
        organizationsService.addTeamToOrganization(id, team);
    }

    @DeleteMapping("/organizations/{id}/removeteam/{team}")
    public void removeHeroFromTeam(@PathVariable Long id, @PathVariable Long team) throws ResourceException {
        organizationsService.removeTeamFromOrganization(id, team);
    }

    @DeleteMapping("/organizations/removeteam/{team}")
    public void removeHeroFromTeam(@PathVariable Long team) throws ResourceException {
        organizationsService.removeTeamFromAllOrganizations(team);
    }
}
