package com.td3.example.demo4.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.*;

@Entity
@Table(name = "heroes_powers")
public class HeroPowerLevel {

    @EmbeddedId
    @JsonIgnore // no need to serialize this key
    private HeroPowerLevelKey id;

    @ManyToOne
    @MapsId("heroId")
    @JoinColumn(name = "hero_id")
    @JsonBackReference // do not serialize hero when the managed reference IS a hero => prevents a recursive serialization
    private Hero hero;

    @ManyToOne
    @MapsId("powerId")
    @JoinColumn(name = "power_id")
    private Power power;

    private int level;

    /* !!! WARNING !!!
        Despite the use of @EmbeddedId, spring DOES NOT initialize itself the id.
        Thus, it is mandatory to create it in every constructors so that we can save instances
        of this class using a repository. Otherwise, a NullPointerException will be raised.
     */
    public HeroPowerLevel(Hero hero, Power power, int level) {
        HeroPowerLevelKey id = new HeroPowerLevelKey(hero.getId(), power.getId());
        this.id = id;
        this.hero = hero;
        this.power = power;
        this.level = level;
    }

    public HeroPowerLevel() {
    }

    public HeroPowerLevelKey getId() {
        return id;
    }

    public void setId(HeroPowerLevelKey id) {
        this.id = id;
    }

    public Hero getHero() {
        return hero;
    }

    public void setHero(Hero hero) {
        this.hero = hero;
    }

    public Power getPower() {
        return power;
    }

    public void setPower(Power power) {
        this.power = power;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String toString() {
        return "PowerLevel{" +
                "id=" + id +
                ", hero=" + hero.getId() +
                ", power=" + power.getId() +
                ", level=" + level +
                '}';
    }
}
