package com.td3.example.demo3.model;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;

import java.util.List;

@Entity
@Table(name = "heroes")
public class Hero {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    // using @Column just to illustrate its possible uses.
    @Column(name="publicname", nullable = false, unique = true, length = 50)
    private String publicName;
    // BdD name will be by default real_name
    private String realName;

    public Hero(Long id, String publicName, String realName ) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
    }

    public Hero(String publicName, String realName ) {
        this.publicName = publicName;
        this.realName = realName;
    }

    public Hero() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    @Override
    public String toString() {
        return "Hero{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                '}';
    }
}
