package com.td3.example.demo3.control;

import com.td3.example.demo3.control.exceptions.ResourceException;
import com.td3.example.demo3.control.exceptions.ResourceNotCreatedException;
import com.td3.example.demo3.model.DTO.HeroDTO;
import com.td3.example.demo3.model.Hero;
import com.td3.example.demo3.service.HeroesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;

    @Autowired
    HeroesController(HeroesService heroesService) {
        this.heroesService = heroesService;
    }

    // get all heroes
    @GetMapping("/heroes")
    public List<Hero> getAllHeroes() {
        List<Hero> list = heroesService.findAll();
        return list;
    }
    // get all heroes with pagination. NB: cannot use the same path as without pagination because return value is of different type
    @GetMapping("/heroes/paging")
    public Page<Hero> getAllHeroesWithPagination(@PageableDefault(page = 0, size = 5)
                                                     @SortDefault.SortDefaults({
                                                             @SortDefault(sort = "id", direction = Sort.Direction.ASC)
                                                     })Pageable pageable) {
        return heroesService.findAllWithPagination(pageable);
    }



    // create a hero
    @PostMapping("/heroes")
    public Hero createHero(@RequestBody HeroDTO hero) throws ResourceException {
        // check if body contains hero details, if not => invalid request
        if (hero == null) {
            throw new ResourceNotCreatedException("invalid body while creating a new hero: no HeroDTO provided");
        }
        return heroesService.createHero( hero.getPublicName(), hero.getRealName());
    }

    // get hero by id
    @GetMapping("/heroes/{id}")
    public Hero getHeroById(@PathVariable Long id) throws ResourceException {
        Hero hero = heroesService.findHeroById(id);
        return hero;
    }

    @DeleteMapping("/heroes/{id}")
    public void deleteHeroById(@PathVariable Long id) throws ResourceException {
        heroesService.deleteHero(id);
    }
}
