package com.td3.example.demo2.service;

import com.td3.example.demo2.control.exceptions.ResourceNotFoundException;
import com.td3.example.demo2.repository.PowerTypesRepository;
import com.td3.example.demo2.repository.PowersRepository;
import com.td3.example.demo2.control.exceptions.ResourceException;
import com.td3.example.demo2.control.exceptions.ResourceNotDeletedException;
import com.td3.example.demo2.model.Power;
import com.td3.example.demo2.model.PowerType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class PowersService {
    private PowersRepository powersRepository;
    private PowerTypesRepository powerTypesRepository;

    @Autowired
    public PowersService(PowersRepository powersRepository, PowerTypesRepository powerTypesRepository) {
        this.powersRepository = powersRepository;
        this.powerTypesRepository = powerTypesRepository;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Power> findAll() {
        return powersRepository.findAll();
    }

    public Power findPowerById(Long id) throws ResourceException {
        Optional<Power> powerOpt = powersRepository.findById(id);
        if (powerOpt.isEmpty()) throw new ResourceNotFoundException("searching for power with id = "+id);
        return powerOpt.get();
    }

    public List<Power> findPowerByPowerType(Long powerTypeId) {
        System.out.println("Getting powers by power type: " + powerTypeId);
        List<Power> list = powersRepository.findAllByPowerTypeId(powerTypeId);
        return list;
    }
    /* *********************************************
       services to create data
    *********************************************** */
    public Power createPower(String name, Long powerTypeId) throws ResourceException {
        Optional<PowerType> powerTypeOpt = powerTypesRepository.findById(powerTypeId);
        if (powerTypeOpt.isEmpty()) throw new ResourceNotFoundException("creating a new power with invalid power type id = "+powerTypeId);
        PowerType powerType = powerTypeOpt.get();
        Power power = new Power(name, powerType);
        powersRepository.save(power);
        return power;
    }

    /* *********************************************
       services to delete data
    *********************************************** */
    public void deletePower(Long id) throws ResourceException {
        Optional<Power> power = powersRepository.findById(id);
        if (power.isEmpty()) throw new ResourceNotFoundException("deleting power with id = "+id);
        try {
            powersRepository.deleteById(id);
        }
        catch(Exception e) {
            throw new ResourceNotDeletedException("relationship with another table prevents from deleting power with id = "+id);
        }
    }

    public void deletePowerType(Long id)  throws ResourceException  {
        Optional<PowerType> powerType = powerTypesRepository.findById(id);
        if (powerType.isEmpty()) throw new ResourceNotFoundException("deleting power type with id = "+id);
        try {
            powerTypesRepository.deleteById(id);
        }
        catch(Exception e) {
            throw new ResourceNotDeletedException("relationship with another table prevents from deleting power type with id = "+id);
        }
    }
}
