package com.td3.example.demo2.service;

import com.td3.example.demo2.control.exceptions.HeroNotFoundException;
import com.td3.example.demo2.model.Hero;
import com.td3.example.demo2.repository.HeroesRepository;
import com.td3.example.demo2.control.exceptions.ResourceException;
import com.td3.example.demo2.control.exceptions.ResourceNotDeletedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Optional;

@Service
public class HeroesService {
    private HeroesRepository heroesRepository;

    @Autowired
    public HeroesService(HeroesRepository heroesRepository) {
        this.heroesRepository = heroesRepository;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Hero> findAll() {
        return heroesRepository.findAll();
    }

    public Hero findHeroById(Long id) throws ResourceException {
        System.out.println("Getting hero by id: " + id);
        Optional<Hero> heroOpt = heroesRepository.findById(id);
        // In case of the hero cannot be found, a HeroNotFoundException is raised. Since it
        // is a sub-subclass of ResourceException, there is no need to modify the header
        // of the current method, by adding throws HeroNotFoundException
        if (heroOpt.isEmpty()) throw new HeroNotFoundException("searching for hero with id = "+id);
        Hero hero = heroOpt.get();
        //System.out.println(hero);
        return hero;
    }

    /* *********************************************
       services to create data
    *********************************************** */

    public Hero createHero(String publicName, String realName) {
        Hero hero = new Hero(publicName, realName);
        heroesRepository.save(hero);
        return hero;
    }

    /* *********************************************
       services to delete data
    *********************************************** */
    public void deleteHero(Long id) throws ResourceException {
        Optional<Hero> heroOpt = heroesRepository.findById(id);
        if (heroOpt.isEmpty()) throw new HeroNotFoundException("deleting hero with id = "+id);
        try {
            heroesRepository.deleteById(id);
        }
        catch(Exception e) {
            throw new ResourceNotDeletedException("relationship with another table prevents from deleting hero with id = "+id);
        }
    }
}
