package com.td3.example.demo2.control;

import com.td3.example.demo2.control.exceptions.ResourceNotFoundException;
import com.td3.example.demo2.model.DTO.SafehouseDTO;
import com.td3.example.demo2.model.Safehouse;
import com.td3.example.demo2.service.SafehousesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class SafehousesController {

    private final SafehousesService safehousesService;

    @Autowired
    SafehousesController(SafehousesService safehousesService) {
        this.safehousesService = safehousesService;
    }

    // get all safehouses
    @GetMapping("/safehouses")
    public List<Safehouse> getAll() throws ResourceNotFoundException {
        return safehousesService.findAll();
    }

    /* create safehouse
        The body does not contain any hero. Heroes must be addded using
        routes for heroes (see HeroesController)
     */
    @PostMapping("/safehouses")
    public Safehouse createSafehouse(@RequestBody SafehouseDTO safehouseDTO) {
        return safehousesService.createSafehouse(safehouseDTO.getName());
    }
    /* get a safehouse by id
       NB : even if a safehouse entity uses a lazy fetch for heroes attribute, returning
       a Safehouse instance in a controller yields a completion of that instance, and thus,
       a request to get the heroes infos. The only way to avoid that is to use a customized
       serialization or a DTO object with only infos about the safehouse
     */

    @GetMapping("/safehouses/{id}")
    public Safehouse getById(@PathVariable Long id) throws ResourceNotFoundException{
        Safehouse safehouse = safehousesService.findSafehouseById(id);
        return safehouse;
    }


    /* version returning a SafehouseDTO to check that lazy fetch really works

    @GetMapping("/safehouses/{id}")
    public SafehouseDTO getById(@PathVariable Long id) throws ResourceNotFoundException{
        Safehouse safehouse = safehousesService.findSafehouseById(id);
        return new SafehouseDTO(safehouse);
    }
    */


    /* add a hero to a a safehouse by id
     */
    @PutMapping("/safehouses/{id}/addhero/{hero}")
    public Safehouse addHero(@PathVariable Long id, @PathVariable Long hero) throws ResourceNotFoundException{
        Safehouse safehouse = safehousesService.addHero(id, hero);
        return safehouse;
    }


    // get a safehouse by name
    @GetMapping("/safehouses/byname/{name}")
    public Safehouse getByName(@PathVariable String name) throws  ResourceNotFoundException{
        Safehouse safehouse = safehousesService.findSafehouseByName(name);
        return safehouse;
    }
}
