package com.td3.example.demo2.control;

import com.td3.example.demo2.control.exceptions.ResourceException;
import com.td3.example.demo2.control.exceptions.ResourceNotCreatedException;
import com.td3.example.demo2.model.DTO.HeroDTO;
import com.td3.example.demo2.model.Hero;
import com.td3.example.demo2.service.HeroesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;

    @Autowired
    HeroesController(HeroesService heroesService) {
        this.heroesService = heroesService;
    }

    // get all heroes
    @GetMapping("/heroes")
    public List<Hero> getAllHeroes() {
        List<Hero> list = heroesService.findAll();
        return list;
    }

    // create a hero
    @PostMapping("/heroes")
    public Hero createHero(@RequestBody HeroDTO hero) throws ResourceException {
        // check if body contains hero details, if not => invalid request
        if (hero == null) {
            throw new ResourceNotCreatedException("invalid body while creating a new hero: no HeroDTO provided");
        }
        return heroesService.createHero( hero.getPublicName(), hero.getRealName());
    }

    // get hero by id
    @GetMapping("/heroes/{id}")
    public Hero getHeroById(@PathVariable Long id) throws ResourceException {
        Hero hero = heroesService.findHeroById(id);
        return hero;
    }

    // delete hero by id
    @DeleteMapping("/heroes/{id}")
    public void deleteHeroById(@PathVariable Long id) throws ResourceException {
        heroesService.deleteHero(id);
    }
}
