package com.td3.example.demo1.model;

import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;

import java.util.List;

@Entity
@Table(name = "heroes")
public class Hero {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    // using @Column just to illustrate its possible uses.
    @Column(name="publicname", nullable = false, unique = true, length = 50)
    private String publicName;
    // BdD name will be by default real_name
    private String realName;

    /* Set a one-to-one (unidirectional) relationship between Hero and HeroDetails.
    There are 2 solutions :
       - 1: heroes table contains a foreign key that corresponds to the primary key of herodetails table.
       - 2: herodetails table contains a foreign key that corresponds to the primary key of heroes table.
    Solution 1 is applied here, for no particular reason.

    Cascading all allows to save a Hero entity without saving first HeroDetails. JPA will do it for us
    Since all is used, it is the same for updating/deleting/...
     */
    @OneToOne(cascade = CascadeType.ALL)
    //@OneToOne
    /* NB one @JoinColumn below:
       - no name given to column for the foreign key => default name is hero_details_id
       - not  nullable => the foreign key cannot be null, which implies that creating a hero
       cannot be done without creating its details first.
    */
    @JoinColumn(nullable = false)
    private HeroDetails heroDetails;

    public Hero(Long id, String publicName, String realName, HeroDetails heroDetails) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.heroDetails = heroDetails;
    }

    public Hero(String publicName, String realName, HeroDetails heroDetails) {
        this.publicName = publicName;
        this.realName = realName;
        this.heroDetails = heroDetails;
    }

    public Hero() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public HeroDetails getHeroDetails() {
        return heroDetails;
    }

    public void setHeroDetails(HeroDetails heroDetails) {
        this.heroDetails = heroDetails;
    }

    @Override
    public String toString() {
        return "Hero{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", heroDetails=" + heroDetails +
                '}';
    }
}
