package com.td3.example.demoAll.service;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.control.exceptions.ResourceNotDeletedException;
import com.td3.example.demoAll.control.exceptions.ResourceNotFoundException;
import com.td3.example.demoAll.model.Organization;
import com.td3.example.demoAll.model.Team;
import com.td3.example.demoAll.repository.OrganizationsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;

@Service
public class OrganizationsService {
    private OrganizationsRepository organizationsRepository;
    private TeamsService teamsService;

    @Autowired
    public OrganizationsService(OrganizationsRepository organizationsRepository, TeamsService teamsService) {
        this.organizationsRepository = organizationsRepository;
        this.teamsService = teamsService;
    }

    /* *********************************************
       services to get data
    *********************************************** */
    public List<Organization> findAll() {
        return organizationsRepository.findAll();
    }

    public Organization findOrganizationById(Long id) throws ResourceException {
        Optional<Organization> organizationOpt = organizationsRepository.findById(id);
        if (organizationOpt.isEmpty()) throw new ResourceNotFoundException("searching for organization with id = "+id);
        return organizationOpt.get();
    }

    /* *********************************************
           services to update data
        *********************************************** */
    public void addTeamToOrganization(Long organizationId, Long teamId) throws  ResourceException {
        Organization organization = findOrganizationById(organizationId);
        Team team = teamsService.findTeamById(teamId);
        organization.getTeams().add(team);
        organizationsRepository.save(organization);
    }

    /* *********************************************
       services to delete data
    *********************************************** */
    public void removeTeamFromOrganization(Long organizationId, Long teamId) throws  ResourceException {
        Organization organization = findOrganizationById(organizationId);
        Team team = teamsService.findTeamById(teamId);
        if (organization.getTeams().remove(team)) {
            organizationsRepository.save(organization);
        }
    }

    public void removeTeamFromAllOrganizations(Long teamId) throws  ResourceException {
        Team team = teamsService.findTeamById(teamId);
        List<Organization> list = organizationsRepository.findAllByTeamsId(teamId);
        for(Organization organization : list) {
            if (organization.getTeams().remove(team)) {
                organizationsRepository.save(organization);
            }
        }
    }
    
    public void deleteOrganization(Long id) throws ResourceException {
        Optional<Organization> organizationOpt = organizationsRepository.findById(id);
        if (organizationOpt.isEmpty()) throw new ResourceNotFoundException("deleting organization with id = "+id);
        try {
            organizationsRepository.deleteById(id);
        }
        catch(Exception e) {
            throw new ResourceNotDeletedException("relationship with another table prevents from deleting organization with id = "+id);
        }
    }
}
