package com.td3.example.demoAll.control;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.model.DTO.TeamDTO;
import com.td3.example.demoAll.model.Team;
import com.td3.example.demoAll.service.TeamsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
public class TeamsController {

    private final TeamsService teamsService;

    @Autowired
    TeamsController(TeamsService teamsService) {
        this.teamsService = teamsService;
    }

    /* !!! WARNING !!!
        controller MUST NOT send back a Team object, counting on the default serialization to
        create the JSON object for the answer's body. Indeed, due to bidirecitonal relationship
        that are not annotated with @JsonManagedReference & @JsonBackReference, this would lead
        to an infinite recursion during serialisation.
        This is why each controller must send back TeamDTO objects, constructed from Team objects.

     */
    // get all teams
    @GetMapping("/teams")
    public List<TeamDTO> getAllTeams() {
        List<Team> list = teamsService.findAll();
        List<TeamDTO> listDTO = new ArrayList<>();
        for(Team team : list) {
            listDTO.add(new TeamDTO(team));
        }
        return listDTO;
    }
    // get team by id
    @GetMapping("/teams/{id}")
    public TeamDTO getTeamById(@PathVariable Long id) throws ResourceException {
        Team team = teamsService.findTeamById(id);
        return new TeamDTO(team);
    }

    // delete team by id
    @DeleteMapping("/teams/{id}")
    public void deleteTeam(@PathVariable Long id) throws ResourceException {
        teamsService.deleteTeam(id);
    }

    @PostMapping("/teams/{id}/addhero/{hero}")
    public void addHeroToTeam(@PathVariable Long id, @PathVariable Long hero) throws ResourceException {
        teamsService.addHeroToTeam(id, hero);
    }

    @DeleteMapping("/teams/{id}/removehero/{hero}")
    public void removeHeroFromTeam(@PathVariable Long id, @PathVariable Long hero) throws ResourceException {
        teamsService.removeHeroFromTeam(id, hero);
    }

    @DeleteMapping("/teams/removehero/{hero}")
    public void removeHeroFromAllTeams(@PathVariable Long hero) throws ResourceException {
        teamsService.removeHeroFromAllTeams(hero);
    }
}
