package com.td3.example.demoAll.control;

import com.td3.example.demoAll.control.exceptions.ResourceNotFoundException;
import com.td3.example.demoAll.model.DTO.SafehouseDTO;
import com.td3.example.demoAll.model.Safehouse;
import com.td3.example.demoAll.service.SafehousesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class SafehousesController {

    private final SafehousesService safehousesService;

    @Autowired
    SafehousesController(SafehousesService safehousesService) {
        this.safehousesService = safehousesService;
    }

    // get all safehouses
    @GetMapping("/safehouses")
    public List<Safehouse> getAll() throws ResourceNotFoundException {
        return safehousesService.findAll();
    }

    /* create safehouse
        The body does not contain any hero. Heroes must be addded using
        routes for heroes (see HeroesController)
     */
    @PostMapping("/safehouses")
    public Safehouse createSafehouse(@RequestBody SafehouseDTO safehouseDTO) {
        return safehousesService.createSafehouse(safehouseDTO.getName());
    }
    // get a safehouse by id
    @GetMapping("/safehouses/{id}")
    public Safehouse getById(@PathVariable Long id) throws ResourceNotFoundException{
        Safehouse safehouse = safehousesService.findSafehouseById(id);
        return safehouse;
    }

    /* add a hero to a a safehouse by id
     */
    @PutMapping("/safehouses/{id}/addhero/{hero}")
    public Safehouse addHero(@PathVariable Long id, @PathVariable Long hero) throws ResourceNotFoundException{
        Safehouse safehouse = safehousesService.addHero(id, hero);
        return safehouse;
    }


    // get a safehouse by name
    @GetMapping("/safehouses/byname/{name}")
    public Safehouse getByName(@PathVariable String name) throws  ResourceNotFoundException{
        Safehouse safehouse = safehousesService.findSafehouseByName(name);
        return safehouse;
    }
}
