package com.td3.example.demoAll.control;

import com.td3.example.demoAll.control.exceptions.ResourceException;
import com.td3.example.demoAll.model.DTO.PowerDTO;
import com.td3.example.demoAll.model.Power;
import com.td3.example.demoAll.service.PowersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class PowersController {

    private final PowersService powersService;

    @Autowired
    PowersController(PowersService powersService) {
        this.powersService = powersService;
    }

    // get all powers
    @GetMapping("/powers")
    public List<Power> getAllPowers() {
        return powersService.findAll();
    }
    // get power by id
    @GetMapping("/powers/{id}")
    public Power getPowerById(@PathVariable Long id) throws ResourceException {
        return powersService.findPowerById(id);
    }
    // get powers by type
    @GetMapping("/powers/bytype/{powerTypeId}")
    public List<Power> getAllPowersByPowerType(@PathVariable Long powerTypeId) {
        List<Power> list = powersService.findPowerByPowerType(powerTypeId);
        return list;
    }

    // create a new power
    @PostMapping("/powers")
    public Power createPower(@RequestBody PowerDTO powerDTO) throws ResourceException {
        return powersService.createPower(powerDTO.getName(), powerDTO.getPowerTypeId());
    }

    @DeleteMapping("/powers/{id}")
    public void deletePower(@PathVariable Long id) throws ResourceException {
        powersService.deletePower(id);
    }

    @DeleteMapping("/powertypes/{id}")
    public void deletePowerType(@PathVariable Long id) throws ResourceException {
        powersService.deletePowerType(id);
    }
}
