package com.td3.example.demo3.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.*;

import java.util.List;

@Entity
@Table(name="organizations")
public class Organization {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Long id;

    @Column(name="name", nullable = false, unique = true, length = 50)
    private String name;
    @Column(name="secret_pass", nullable = false, unique = true, length = 100)
    private String secretPass;

    /* Set a many-to-many bidirectional relationship between organizations and teams, i.e.
    an organization may have several teams, and a team may be in several organizations.
    It implies to create another table with 2 foreign keys that represent the 2 primary keys of
    organisation and team tables.

    This class is the "owner" side of the relation, i.e. the side that declares the name of the new table,
    and the name of the 2 columns that contains the foreign keys. Dor that, the column for the owner must be
    specified with joinColumns parameter, and the column for the "owned" side specified with inverseJoinColumns parameter.
     */
    @ManyToMany
    @JoinTable(name = "organizations_teams",
            joinColumns = @JoinColumn(name = "organization_id"),
            inverseJoinColumns = @JoinColumn(name = "team_id"))
    @JsonBackReference
    private List<Team> teams;

    public Organization(Long id, String name, String secretPass, List<Team> teams) {
        this.id = id;
        this.name = name;
        this.secretPass = secretPass;
        this.teams = teams;
    }

    public Organization(String name, String secretPass, List<Team> teams) {
        this.name = name;
        this.secretPass = secretPass;
        this.teams = teams;
    }

    public Organization() {
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretPass() {
        return secretPass;
    }

    public void setSecretPass(String secretPass) {
        this.secretPass = secretPass;
    }

    public List<Team> getTeams() {
        return teams;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    @Override
    public String toString() {
        return "Organization{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", secretPass='" + secretPass + '\'' +
                ", teams=" + teams +
                '}';
    }
}
