package com.td3.example.demo2.control.filters;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.td3.example.demo2.model.Hero;

import java.io.IOException;
import java.util.List;

public class CustomHeroListSerializer extends StdSerializer<List<Hero>> {

    private static final long serialVersionUID = 1L;

    public CustomHeroListSerializer() {
        this(null);
    }
    public CustomHeroListSerializer(Class<List<Hero>> t) {
        super(t);
    }
    @Override
    public void serialize(List<Hero> list, JsonGenerator generator, SerializerProvider arg2) throws IOException {
        generator.writeStartArray();
        for(Hero h : list) {
            generator.writeStartObject();
            generator.writeNumberField("id",h.getId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }
}

