package com.td3.example.demo2.commons;

import java.util.HashMap;
import java.util.Map;

public final class ErrorList {

    public static final Integer NOERROR = 0;
    public static final Integer RESOURCE_ERROR = 1;
    public static final Integer RESOURCE_NOT_FOUND = 100;
    public static final Integer HERO_NOT_FOUND = 101;
    public static final Integer RESOURCE_NOT_CREATED = 200;
    public static final Integer RESOURCE_NOT_UPDATED = 300;
    public static final Integer RESOURCE_NOT_DELETED = 400;

    public static Map<Integer, String> errorList;
    static {
        errorList = new HashMap<>();
        errorList.put(NOERROR, "no error");
        errorList.put(RESOURCE_ERROR, "error concerning a resource");
        errorList.put(RESOURCE_NOT_FOUND, "resource not found");
        errorList.put(HERO_NOT_FOUND, "hero not found");
        errorList.put(RESOURCE_NOT_CREATED, "resource not created");
        errorList.put(RESOURCE_NOT_UPDATED, "resource not updated");
        errorList.put(RESOURCE_NOT_DELETED, "resource not deleted");
    }

    public static void register(Integer number, String message) {
        if ((!errorList.containsKey(number)) && (!errorList.containsValue(message)) )  {
            errorList.put(number, message);
        }
    }

    public static String getMessage(Integer number) {
        if (errorList.containsKey(number)) return errorList.get(number);
        return "";
    }

}
