package com.td3.example.demo1.control.exceptions;

import com.td3.example.demo1.commons.ErrorList;

public class ResourceException extends RuntimeException {

    /* NB: in order to build a request answer to the http request that is of format :
    { errorNumber: ..., context: ..., message: ...}, this class dcalres two attributes
    that represent the error number and the context, i.e. the operation that yielded an error
     */
    protected Integer errorNumber;
    protected String context;

    public ResourceException(Integer errorNumber, String context, String message) {
        super(message);
        this.errorNumber = errorNumber;
        this.context = context;
    }

    public ResourceException(String context) {
        this(ErrorList.RESOURCE_ERROR, context, ErrorList.getMessage(ErrorList.RESOURCE_ERROR));
    }

    public ResourceException() {
        this(ErrorList.RESOURCE_ERROR, "", ErrorList.getMessage(ErrorList.RESOURCE_ERROR));
    }

    public Integer getErrorNumber() {
        return errorNumber;
    }

    public String getContext() {
        return context;
    }
}
