package com.td3.example.demo1.control;

import com.td3.example.demo1.control.exceptions.ResourceException;
import com.td3.example.demo1.control.exceptions.ResourceNotCreatedException;
import com.td3.example.demo1.service.HeroesService;
import com.td3.example.demo1.model.DTO.HeroDTO;
import com.td3.example.demo1.model.Hero;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;

    @Autowired
    HeroesController(HeroesService heroesService) {
        this.heroesService = heroesService;
    }

    // get all heroes
    @GetMapping("/heroes")
    public List<Hero> getAllHeroes() {
        List<Hero> list = heroesService.findAll();
        return list;
    }

    // create a hero
    @PostMapping("/heroes")
    public Hero createHero(@RequestBody HeroDTO hero) throws ResourceException {
        // check if body contains hero details, if not => invalid request
        if (hero == null) {
            throw new ResourceNotCreatedException("invalid body while creating a new hero: no HeroDTO provided");
        }
        else if (hero.getHeroDetails() == null) {
            throw new ResourceNotCreatedException("invalid body while creating a new hero: no details on hero provided");
        }
        return heroesService.createHero( hero.getPublicName(), hero.getRealName(), hero.getHeroDetails().getBirthday(), hero.getHeroDetails().getBio(),  hero.getHeroDetails().getSize(),  hero.getHeroDetails().getWeight());
    }

    // update hero (only names & details) by id
    @PutMapping("/heroes")
    public Hero updateHero(@RequestBody HeroDTO hero) throws ResourceException {
        if (hero == null) {
            throw new ResourceNotCreatedException("invalid body while updating a hero: no HeroDTO provided");
        }

        if (hero.getHeroDetails() != null) {
            return heroesService.updateHero(hero.getId(), hero.getPublicName(), hero.getRealName(), hero.getHeroDetails().getBirthday(), hero.getHeroDetails().getBio(), hero.getHeroDetails().getSize(), hero.getHeroDetails().getWeight());
        }
        return heroesService.updateHero(hero.getId(), hero.getPublicName(), hero.getRealName(), null, null, null, null);
    }

    // get hero by id
    @GetMapping("/heroes/{id}")
    public Hero getHeroById(@PathVariable Long id) throws ResourceException {
        Hero hero = heroesService.findHeroById(id);
        return hero;
    }

    // delete hero by id
    @DeleteMapping("/heroes/{id}")
    public void deleteHeroById(@PathVariable Long id) throws ResourceException {
        heroesService.deleteHero(id);
    }
}
