package com.td3.example.demo1.control;

import com.td3.example.demo1.control.exceptions.ResourceNotCreatedException;
import com.td3.example.demo1.control.exceptions.ResourceNotDeletedException;
import com.td3.example.demo1.control.exceptions.ResourceNotFoundException;
import com.td3.example.demo1.control.exceptions.ResourceNotUpdatedException;
import com.td3.example.demo1.model.DTO.ErrorDTO;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ControllerAdvice {

    // NB: even if this is an exception handler for the ResourceNotFoundException, it is able
    // to manage exceptions of ResourceNotFoundException subclasses, as HeroNotFoundException
    @ExceptionHandler(ResourceNotFoundException.class)
    @ResponseStatus(HttpStatus.NOT_FOUND)
    ErrorDTO resourceNotFoundHandler(ResourceNotFoundException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }

    @ExceptionHandler(ResourceNotCreatedException.class)
    @ResponseStatus(HttpStatus.UNPROCESSABLE_ENTITY)
    ErrorDTO resourceNotCreatedHandler(ResourceNotCreatedException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }

    @ExceptionHandler(ResourceNotUpdatedException.class)
    @ResponseStatus(HttpStatus.UNPROCESSABLE_ENTITY)
    ErrorDTO resourceNotUpdatedHandler(ResourceNotUpdatedException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }

    @ExceptionHandler(ResourceNotDeletedException.class)
    @ResponseStatus(HttpStatus.FAILED_DEPENDENCY)
    ErrorDTO resourceNotDeletedHandler(ResourceNotDeletedException ex) {
        return new ErrorDTO(ex.getErrorNumber(), ex.getContext(), ex.getMessage());
    }
}
