package com.td2.example.demo2.control.exceptions;

import com.td2.example.demo2.commons.ErrorList;

public class CSVConversionException extends RuntimeException {

    /* NB: in order to build a request answer to the http request that is of format :
    { errorNumber: ..., context: ..., message: ...}, this class dcalres two attributes
    that represent the error number and the context, i.e. the operation that yielded an error
     */
    protected Integer errorNumber;
    protected String context;

    public CSVConversionException(Integer errorNumber, String context, String message) {
        super(message);
        this.errorNumber = errorNumber;
        this.context = context;
    }

    public CSVConversionException(String context) {
        this(ErrorList.INVALID_CSV, context, ErrorList.getMessage(ErrorList.INVALID_CSV));
    }

    public CSVConversionException() {
        this(ErrorList.INVALID_CSV, "", ErrorList.getMessage(ErrorList.INVALID_CSV));
    }

    public Integer getErrorNumber() {
        return errorNumber;
    }

    public String getContext() {
        return context;
    }
}
