package com.td2.example.demo2.control;

import com.td2.example.demo2.control.exceptions.CSVConversionException;
import com.td2.example.demo2.control.exceptions.ResourceNotFoundException;
import com.td2.example.demo2.model.Hero;
import com.td2.example.demo2.model.DTO.HeroDTO;
import com.td2.example.demo2.service.CSVService;
import com.td2.example.demo2.service.HeroesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.SortDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
public class HeroesController {

    private final HeroesService heroesService;
    private final CSVService csvService;

    @Autowired
    HeroesController(HeroesService heroesService, CSVService csvService) {
        this.heroesService = heroesService;
        this.csvService = csvService;
    }

    // get all heroes
    @GetMapping("/heroes")
    public List<Hero> getAllHeroes() {
        List<Hero> list = heroesService.findAll();
        return list;
    }

    @PostMapping("/heroes/upload")
    public void uploadCSVForHeroes(@RequestParam("file") MultipartFile file) throws CSVConversionException {
        csvService.saveCSVToHeroes(file);
    }
}
