package com.td2.example.demo2.commons;

import java.util.HashMap;
import java.util.Map;

public final class ErrorList {

    public static final Integer NOERROR = 0;
    public static final Integer RESOURCE_NOT_FOUND = 100;
    public static final Integer HERO_NOT_FOUND = 101;

    // CSV related errors
    public static final Integer INVALID_CSV = 1000;

    public static Map<Integer, String> errorList;
    static {
        errorList = new HashMap<>();
        errorList.put(NOERROR, "no error");
        errorList.put(RESOURCE_NOT_FOUND, "resource not found");
        errorList.put(HERO_NOT_FOUND, "hero not found");
        errorList.put(INVALID_CSV, "CSV file is invalid");
    }

    public static void register(Integer number, String message) {
        if ((!errorList.containsKey(number)) && (!errorList.containsValue(message)) )  {
            errorList.put(number, message);
        }
    }

    public static String getMessage(Integer number) {
        if (errorList.containsKey(number)) return errorList.get(number);
        return "";
    }

}
