package com.td2.example.demo2.model.DTO;

/*
This class is used to represent a Hero object received from a client of this
application. Instances of this class are automatically build by spring when a controller
as a HeroDTO parameter annotated with @RequestBody ( see createHero(), updateHero() )
 */
public class HeroDTO {

    /*
    In order to be able to receive updated info about a hero, but without
    all fields provided, it is useful to declare all attributes as object.
    Indeed, when receiving a JSON with missing fields, spring will deserialize
    it in a HeroDTO instance setting null to attributes that correspond to a missing field.
     */
    private Long id;
    private String publicName;
    private String realName;
    private String power;
    private Integer powerLevel;

    public HeroDTO(Long id, String publicName, String realName, String power, Integer powerLevel) {
        this.id = id;
        this.publicName = publicName;
        this.realName = realName;
        this.power = power;
        this.powerLevel = powerLevel;
    }

    public HeroDTO() {
        this(null,null,null,null,null);
    }

    public HeroDTO(String publicName, String realName, String power, Integer powerLevel) {
        this(null, publicName, realName, power, powerLevel);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPublicName() {
        return publicName;
    }

    public void setPublicName(String publicName) {
        this.publicName = publicName;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getPower() {
        return power;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public Integer getPowerLevel() {
        return powerLevel;
    }

    public void setPowerLevel(Integer powerLevel) {
        this.powerLevel = powerLevel;
    }

    @Override
    public String toString() {
        return "HeroDTO{" +
                "id=" + id +
                ", publicName='" + publicName + '\'' +
                ", realName='" + realName + '\'' +
                ", power='" + power + '\'' +
                ", powerLevel=" + powerLevel +
                '}';
    }
}
